<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckAdmin
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Verifica se o utilizador NÃO está logado OU se NÃO é um admin
        if (!Auth::check() || $request->user()->tipo_usuario !== 'admin') {
            // Se não for admin, bloqueia o acesso.
            return response()->json(['message' => 'Acesso não autorizado.'], 403); // 403 = Proibido
        }

        // Se for admin, permite que a requisição continue.
        return $next($request);
    }
}