<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestimentoUsuario extends Model
{
    use HasFactory;

    protected $table = 'investimentos_usuario';

    // *** LINHAS ADICIONADAS ***
    // Campos que podemos preencher em massa
    protected $fillable = [
        'usuario_id',
        'oportunidade_id',
        'transacao_id',
        'valor_investido',
        'status',
        'data_conclusao_prevista',
    ];
    // *** FIM DAS LINHAS ADICIONADAS ***

    /**
     * Relação: Um "Investimento" PERTENCE A UMA "Oportunidade"
     */
    public function oportunidade()
    {
        return $this->belongsTo(Oportunidade::class, 'oportunidade_id');
    }
}