<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('oportunidades', function (Blueprint $table) {
            $table->id();

            // Chave estrangeira para saber quem criou (um Admin ou Corretor)
            $table->foreignId('criador_id')->constrained('usuarios');

            // O campo mais importante: distingue Imóvel de Investimento
            $table->enum('tipo_oportunidade', ['investimento', 'imovel']);

            $table->string('titulo');
            $table->string('slug')->unique(); // Para URLs amigáveis (ex: /investir/invest-in-land)
            $table->text('descricao_curta')->nullable();
            $table->string('imagem_destaque_path')->nullable(); // Caminho para a imagem principal

            // Status da oportunidade
            $table->enum('status', [
                'ativo',        // Disponível para investir/comprar
                'rascunho',     // Admin está a criar, não é público
                'financiado',   // Meta de investimento atingida
                'vendido',      // Imóvel vendido
                'expirado'      // Prazo acabou
            ])->default('rascunho');

            // Valores principais
            $table->decimal('valor_meta', 15, 2)->default(0.00);
            $table->decimal('valor_arrecadado', 15, 2)->default(0.00);

            $table->date('data_inicio')->nullable(); // Data de início da campanha
            $table->date('data_fim')->nullable(); // Data limite para investir

            $table->timestamps(); // created_at e updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('oportunidades');
    }
};