<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('oportunidade_meta_investimento', function (Blueprint $table) {
            $table->id();

            $table->foreignId('oportunidade_id')
                  ->unique() 
                  ->constrained('oportunidades')
                  ->onDelete('cascade');

            $table->decimal('investimento_min', 15, 2)->default(0.00);
            $table->decimal('investimento_max', 15, 2)->default(0.00);
            $table->string('roi_estimado')->nullable(); 
            $table->string('duracao_investimento')->nullable();
            $table->string('categoria')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('oportunidade_meta_investimento');
    }
};