<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // AQUI ESTAVA O ERRO (publicS) - AGORA ESTÁ CORRIGIDO
    public function up(): void
    {
        Schema::create('oportunidade_conteudo', function (Blueprint $table) {
            $table->id();

            $table->foreignId('oportunidade_id')
                  ->constrained('oportunidades')
                  ->onDelete('cascade');

            $table->enum('tipo_aba', [
                'visao_geral',
                'plano',
                'analise',
                'faq',
                'acordo'
            ]);

            $table->string('titulo_aba');
            $table->longText('conteudo');
            $table->unique(['oportunidade_id', 'tipo_aba']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('oportunidade_conteudo');
    }
};