<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabela mestre de todo o dinheiro que entra e sai
        Schema::create('transacoes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('usuario_id')->constrained('usuarios');

            // O tipo de transação (essencial para filtrar o histórico)
            $table->enum('tipo_transacao', [
                'deposito',         // Dinheiro entrando na plataforma (Ex: PIX, Manual)
                'retirada',         // Dinheiro saindo da plataforma
                'investimento',     // Dinheiro movido de 'saldo_disponivel' para 'saldo_bloqueado'
                'retorno_lucro',    // Lucro (ROI) sendo pago ao 'saldo_disponivel'
                'retorno_principal',// Valor principal sendo devolvido ao 'saldo_disponivel'
                'comissao',         // Comissão de indicação paga
                'taxa'              // Taxa da plataforma (Ex: taxa de retirada)
            ]);

            // Status da transação (para aprovação de depósitos/retiradas)
            $table->enum('status', ['pendente', 'concluido', 'falhou', 'rejeitado'])->default('pendente');
            
            $table->decimal('valor', 15, 2);
            
            $table->string('gateway_pagamento')->nullable(); // Ex: "PIX", "Manual", "PayPal"
            $table->string('gateway_txid')->nullable()->index(); // ID da transação no gateway
            
            $table->text('notas_admin')->nullable(); // Ex: "Motivo da rejeição da retirada"

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transacoes');
    }
};