<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Esta tabela liga um Usuário a uma Oportunidade (Meu Investimento)
        Schema::create('investimentos_usuario', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('usuario_id')->constrained('usuarios');
            $table->foreignId('oportunidade_id')->constrained('oportunidades');
            
            // Opcional, mas muito útil: qual transação originou este investimento
            $table->foreignId('transacao_id')->nullable()->constrained('transacoes');
            
            $table->decimal('valor_investido', 15, 2);
            
            $table->enum('status', ['ativo', 'concluido', 'cancelado'])->default('ativo');
            
            // Para a funcionalidade "Retorno pendente"
            $table->date('data_conclusao_prevista')->nullable(); 

            $table->timestamps();

            // Opcional: Evita que o mesmo usuário invista duas vezes na mesma oportunidade.
            // Remova esta linha se o usuário puder fazer múltiplos investimentos no mesmo "Caso".
            $table->unique(['usuario_id', 'oportunidade_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('investimentos_usuario');
    }
};