<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comissoes_indicacao', function (Blueprint $table) {
            $table->id();

            // Quem recebeu a comissão (o "pai" ou indicador)
            $table->foreignId('usuario_id')
                  ->constrained('usuarios')
                  ->onDelete('cascade');

            // Quem gerou a comissão (o "filho" ou indicado)
            $table->foreignId('indicado_usuario_id')
                  ->constrained('usuarios')
                  ->onDelete('cascade');

            // Qual transação originou esta comissão (Ex: o primeiro depósito do indicado)
            $table->foreignId('transacao_origem_id')
                  ->constrained('transacoes')
                  ->onDelete('cascade');
            
            // Valor da comissão
            $table->decimal('valor_comissao', 15, 2);

            // Status da comissão
            $table->enum('status', ['pendente', 'pago', 'cancelado'])->default('pendente');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comissoes_indicacao');
    }
};