<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema; // A linha 5 estava errada, esta está correta

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assinantes', function (Blueprint $table) {
            $table->id();

            $table->string('email')->unique();

            $table->enum('status', ['assinado', 'cancelado'])->default('assinado');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assinantes');
    }
};